<?php $__env->startSection('title', __('report.stock_report')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>Product Stock Report</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
              <?php echo Form::open(['url' => action('ReportController@getStockReport'), 'method' => 'get', 'id' => 'stock_report_filter_form' ]); ?>

                
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('category_id', __('category.category') . ':'); ?>

                        <?php echo Form::select('category', $categories, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'category_id']);; ?>

                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('brand', __('product.brand') . ':'); ?>

                        <?php echo Form::select('brand', $brands, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%']);; ?>

                    </div>
                </div>
                 <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('brand', 'Thickness :'); ?>

                        <select class="form-control select2" style="width:100%" id="thickness" name="thickness">
                            <option value="">All</option>
                            <?php foreach($thickness as $t){ ?>
                                <option value="<?=$t->product_custom_field1?>"><?=$t->product_custom_field1?></option>
                            <?php } ?>
                            
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('brand', 'Size :'); ?>

                        <select class="form-control select2" style="width:100%" id="size" name="size">
                            <option value="">All</option>
                            <?php foreach($size as $t){ ?>
                                <option value="<?=$t->product_custom_field2?>"><?=$t->product_custom_field2?></option>
                            <?php } ?>
                            
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <?php echo Form::label('brand', 'Color :'); ?>

                        <select class="form-control select2" style="width:100%" id="color" name="color">
                            <option value="">All</option>
                            <?php foreach($color as $t){ ?>
                                <option value="<?=$t->product_custom_field3?>"><?=$t->product_custom_field3?></option>
                            <?php } ?>
                            
                        </select>
                    </div>
                </div>
                
                
                <?php echo Form::close(); ?>

            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_product_stock_value')): ?>
    <div class="row" hidden>
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>
            <table class="table no-border">
                <tr>
                    <td><?php echo app('translator')->getFromJson('report.closing_stock'); ?> (<?php echo app('translator')->getFromJson('lang_v1.by_purchase_price'); ?>)</td>
                    <td><?php echo app('translator')->getFromJson('report.closing_stock'); ?> (<?php echo app('translator')->getFromJson('lang_v1.by_sale_price'); ?>)</td>
                    <td><?php echo app('translator')->getFromJson('lang_v1.potential_profit'); ?></td>
                    <td><?php echo app('translator')->getFromJson('lang_v1.profit_margin'); ?></td>
                </tr>
                <tr>
                    <td><h3 id="closing_stock_by_pp" class="mb-0 mt-0"></h3></td>
                    <td><h3 id="closing_stock_by_sp" class="mb-0 mt-0"></h3></td>
                    <td><h3 id="potential_profit" class="mb-0 mt-0"></h3></td>
                    <td><h3 id="profit_margin" class="mb-0 mt-0"></h3></td>
                </tr>
            </table>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-md-12">
            <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>
            <center style="padding-bottom:10px;"><button id="printBtn" class="btn btn-success btn-sm"><i class="fa fa-print"></i> Print Stock Report</button></center>
                <table class="table table-bordered table-striped" id="product_stock_report_table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Thickness</th>
                            <th>Size</th>
                            <th>Color</th>
                            <th>H.O Stock</th>
                            <th>B.O Stock</th>
                            <th>Total Stock</th>
                            <th>Category</th>
                            <th>Brand</th>
                        </tr>
                    </thead>
                </table>
            <?php echo $__env->renderComponent(); ?>
        </div>
         
    </div>
</section>

<style>
        @media  print {
            /* Define styles for the header */
            .header {
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                text-align: center;
                background-color: #f2f2f2;
                padding: 10px;
                border-bottom: 1px solid #ccc;
            }

            /* Define styles for the table */
            .table-container {
                margin-top: 50px; /* Adjust to leave space for the header */
            }

            /* Set printing margins */
            @page  {
                margin: 1mm; /* Adjust margin value as needed */
            }
        }
    </style>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v), false); ?>"></script>
    
    
    <script>
        $(document).ready(function() {
             var product_stock_report_cols = [
                    { data: 'name', name: 'name' },
                    { data: 'product_custom_field1', name: 'product_custom_field1' },
                    { data: 'product_custom_field2', name: 'product_custom_field2' },
                    { data: 'product_custom_field3', name: 'product_custom_field3' },
                    { data: 'ho', name: 'ho', searchable: false },
                    { data: 'bo', name: 'bo', searchable: false },
                    { data: 'total', name: 'total', searchable: false },
                    { data: 'category_name', name: 'categories.name' },
                    { data: 'brand_name', name: 'brands.name' },
                    
                ];        
                    
            //Stock report table
            product_stock_report_table = $('#product_stock_report_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: '/reports/product-stock-report',
                    data: function(d) {
                        d.category_id = $('#category_id').val();
                        d.brand_id = $('#brand').val();
                        d.thickness = $('#thickness').val();
                        d.size = $('#size').val();
                        d.color = $('#color').val();
                    },
                },
                columns: product_stock_report_cols,
            });
            
            
            
        });
        
        $(document).on('change', '#category_id, #brand, #thickness, #size, #color', function(){
                product_stock_report_table.ajax.reload();
            });
        
        
        $(document).ready(function() {
            $('#printBtn').click(function() {
                var printContents = '<center style="padding:2px 5px;font-size:18px;"><b>Sun Lamination Stock Report</b></center>';
                var category_name=$('#category_id option:selected').text();
                var brand_name=$('#brand option:selected').text();
                var thickness_name=$('#thickness option:selected').text();
                var size_name=$('#size option:selected').text();
                var color_name=$('#color option:selected').text();
                
                
                if(category_name!=''){
                    printContents = printContents+'<center style="padding:2px 5px;">Category : <b>'+category_name+'</b></center>';
                }
                if(brand_name!=''){
                    printContents = printContents+'<center style="padding:2px 5px;">Brand : <b>'+brand_name+'</b></center>';
                }
                printContents = printContents+'<center style="padding:2px 5px;">Thikness : <b>'+thickness_name+'</b>,Brand : <b>'+brand_name+'</b>,Size : <b>'+size_name+'</b>,Color : <b>'+color_name+'</b></center>';
                printContents=printContents+'<table style="width:100%;"><thead><tr><th style="border:1px solid black;padding:2px 5px;">Name</th><th style="border:1px solid black;padding:2px 5px;">Color</th><th style="border:1px solid black;padding:2px 5px;">HO</th><th style="border:1px solid black;padding:2px 5px;">Bo</th><th style="border:1px solid black;padding:2px 5px;">Stock</th></thead></tr><tbody>';
                
                var to_ho=0;to_bo=0;to_total=0;
                
                
                $('table#product_stock_report_table tbody tr').each(function() {
                    var name = $(this).find('td:first').text().trim(); 
                    var thickness = $(this).find('td:eq(1)').text().trim(); 
                    var size = $(this).find('td:eq(2)').text().trim();
                    var color = $(this).find('td:eq(3)').text().trim();
                    var ho = $(this).find('td:eq(4)').text().trim();
                    to_ho=parseInt(to_ho)+parseInt(ho);
                    var bo = $(this).find('td:eq(5)').text().trim();
                    to_bo=parseInt(to_bo)+parseInt(bo);
                    var total = $(this).find('td:eq(6)').text().trim();
                    to_total=parseInt(to_total)+parseInt(total);
                    printContents=printContents+'<tr><td style="border:1px solid black;padding:2px 5px;">'+name+'</td><td style="border:1px solid black;padding:2px 5px;">'+color+'</td><td style="border:1px solid black;padding:2px 5px;text-align:right;">'+ho+'</td><td style="border:1px solid black;padding:2px 5px;text-align:right;">'+bo+'</td><td style="border:1px solid black;padding:2px 5px;text-align:right;">'+total+'</td></tr>';
                });
                printContents=printContents+'<tr><td style="border:1px solid black;padding:2px 5px;"></td><td style="border:1px solid black;padding:2px 5px;"></td><td style="border:1px solid black;padding:2px 5px;">'+to_ho+'</td><td style="border:1px solid black;padding:2px 5px;">'+to_bo+'</td><td style="border:1px solid black;padding:2px 5px;">'+to_total+'</td></tr>';
                printContents=printContents+'</table>';
                var originalContents = document.body.innerHTML;
                document.body.innerHTML = printContents;
                window.print();location.reload();
            });
        });
       
    </script>
     
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fmsbilling/public_html/offer-electronics-new/resources/views/report/product_stock_report.blade.php ENDPATH**/ ?>